(*| 16:21 24/10/1994 *)
PROGRAM CAT;

{ Author B.R.D. Whitnall }
{ Revision History }
{ 1.1 26/06/88 }
{ 2.6 11/01/91 }
{ 2.6 12/04/93 }
{ 2.7 20/03/94 DirData moved to heap, MaxDir increased from 12k to 16k }
{ 3.0 21/05/94 Split into units CATUTILS, ARCHIVES with some restructuring}
{              added LZH and ARJ handling, embedded mixed archives }
{ 3.1 24/10/94 MaxDir increased from 12k to 15k7.  Mark/Release dropped}

USES Crt,Dos,Printer,CatUtils,Archives;

{$F+}
PROCEDURE DoArchiveProc(FileText: PathStr;
                        FTimeDate, FSize: LongInt;
                        FAttr: Word;
                        AType: TArchiveType;
                        ArcLevel: Integer);
VAR
  Sign: Char;
BEGIN
  IF CheckFileSpec(FileText) THEN BEGIN
    INC(NumOfFiles);
    CASE AType OF
      TArc:INC(NumOfArcFiles);
      TLzh:INC(NumOfLzhFiles);
      TZip:INC(NumOfZipFiles);
      TArj:INC(NumOfArjFiles);
    END;
    IF ArcLevel = 1 THEN
      Sign := '+'
    ELSE
      Sign := '*';
    ProcessThisFileText(FixString(FileText,12)+Sign,FTimeDate,FSize);
    FoundFile:=True;
    FoundInWhere:=True;
    IF FindDir THEN
      HALT;
  END;
END;  { DoArchiveProc }
{$F-}

PROCEDURE ShowArcFiles;
BEGIN
  FindFirst('*.ARC',Archive,FindRec);
  WHILE DosError=0 DO WITH FindRec DO BEGIN
    ShowWhere(Name);
    ProcessThisArcFile(Name, DoArchiveProc);
    FindNext(FindRec);
    IF AbortTest THEN Exit;
  END;
(*  Writeln;*)
END; { ShowArcFiles }

PROCEDURE ShowLzhFiles;
BEGIN
  FindFirst('*.LZH',Archive,FindRec);
  WHILE DosError=0 DO WITH FindRec DO BEGIN
    ShowWhere(Name);
    ProcessThisLzhFile(Name, DoArchiveProc);
    FindNext(FindRec);
    IF AbortTest THEN Exit;
  END;
(*  Writeln;*)
END; { ShowLzhFiles }

PROCEDURE ShowZipFiles;
BEGIN
  FindFirst('*.ZIP',Archive,FindRec);
  WHILE DosError=0 DO WITH FindRec DO BEGIN
    ShowWhere(Name);
    ProcessThisZipFile(Name, DoArchiveProc);
    FindNext(FindRec);
    IF AbortTest THEN Exit;
  END;
(*  Writeln;*)
END; { ShowZipFiles }

PROCEDURE ShowArjFiles;
BEGIN
  FindFirst('*.ARJ',Archive,FindRec);
  WHILE DosError=0 DO WITH FindRec DO BEGIN
    ShowWhere(Name);
    ProcessThisArjFile(Name, DoArchiveProc);
    FindNext(FindRec);
    IF AbortTest THEN Exit;
  END;
(*  Writeln;*)
END; { ShowArjFiles }

PROCEDURE ScanDir;
BEGIN
  ShowFiles;
  IF NOT NoArc THEN BEGIN
    ShowArcFiles;
    ShowZipFiles;
    ShowLzhFiles;
    ShowArjFiles;
  END;
  FindFirst('*.',Directory,FindDirRec[Level]);
  WHILE DosError=0 DO BEGIN
    IF Abort THEN Exit;
    GetDir(DriveNum,TextLine);
    IF TextLine[Length(TextLine)] <> '\' THEN
      TextLine:=TextLine+'\';
    ThisDirName:=FindDirRec[Level].Name;
    IF (FindDirRec[Level].Attr AND Directory) <> 0 THEN BEGIN
      IF ThisDirName[1] <> '.' THEN BEGIN
        ShowWhere(TextLine+ThisDirName);
        ChDir(ThisDirName);
        INC(Level);
        ScanDir;            { Recursive call for subdirectories }
        ChDir('..');
        DEC(Level);
      END;
    END;
    FindNext(FindDirRec[Level]);
  END;
END; { ScanDir }

PROCEDURE FloppyAbort;
BEGIN
  IF Floppy THEN BEGIN
    Writeln(MaxAvail,' free memory. Scan another disk Y/N ? ');
    C:=Readkey;
    IF Upcase(C) <> 'Y' THEN Abort:=True;
  END;
END;  { FloppyAbort }

BEGIN
  Writeln('Disk Catalogue Program by B Whitnall, V3.1');
  OptionString:='';
  FileSpec:='*.*';
  SaveToFile:=False;
  ListFileName:='CATDIR.TXT';
  IF ParamCount > 0 THEN FOR I:=1 TO ParamCount DO BEGIN
    TextLine:=UpperCase(ParamStr(I));
    IF TextLine[1] = '/' THEN
      OptionString:=OptionString + TextLine
    ELSE BEGIN
      IF I = 1 THEN
        FileSpec:=TextLine;
      IF I = 2 THEN BEGIN
        ListFileName:=TextLine;
        SaveToFile:=True;
      END;
    END;
  END;
  IF FileSpec = '?' THEN ShowHelp;
  I:=POS(':',FileSpec);
  IF I = 0 THEN
    BEGIN
      ChosenDrive:='';
      DriveNum:=0;
    END
  ELSE BEGIN
    ChosenDrive:=COPY(FileSpec,1,I);
    DriveNum:=ORD(UpCase(ChosenDrive[1]))-$40;
    IF Length(FileSpec) = I THEN
      FileSpec:=FileSpec+'*.*';
  END;
  IF POS('\',FileSpec) > 0 THEN BEGIN
    Writeln('Warning - Path specification not supported.');
    HALT;
  END;
  I:=POS('.',FileSpec);
  IF I = 0 THEN BEGIN
    Writeln('Warning - No File Extension specified.');
    HALT;
  END;
  FileBody:=COPY(FileSpec,1,I-1);
  FileBody:=COPY(FileBody,POS(':',FileBody)+1,8);
  FileExt:=COPY(FileSpec,I+1,3);
  ProcessOptions;
  IF Append THEN AppendFile;
  GetDir(0,OriginalPath);
  IF (DriveNum = 1) OR (DriveNum = 2) THEN
    Floppy:=True
  ELSE
    Floppy:=False;
  Abort:=False;
{ Mark(MemMark);}
  REPEAT
    IF Floppy THEN BEGIN
      Write('Name for this floppy : ');
      Readln(FloppyName);
      IF FloppyName <> '' THEN
        SetFloppyNum
      ELSE BEGIN
        INC(FloppyNum);
        FloppyName:=IntToString(FloppyNum,3);
        Writeln('Floppy ',FloppyName);
      END;
      IF Update THEN
        DeleteOldFloppy;
    END;
{$I-}
    ChDir(ChosenDrive);
    IF ResultOK THEN BEGIN
      GetDir(0,DestPath);
      IF ResultOK THEN BEGIN
        LastResultOK:=True;
        IF NOT CurAndSub THEN BEGIN
          IF FindDir THEN BEGIN
            Level:=1;
            ThisDirName:='';
            GetDir(DriveNum,TextLine);
{$I+}
            ScanDir;
{$I-}
          END;
          ChDir(ChosenDrive+'\');
          IF NOT ResultOK THEN
            LastResultOK:=False;
        END;
        IF LastResultOK THEN BEGIN
          Level:=1;
          ThisDirName:='';
          GetDir(DriveNum,TextLine);
          IF ResultOK THEN
{$I+}
            ScanDir;
        END;
      END;
    END;
{$I+}
    FloppyAbort;
    IF NOT (CurAndSub OR Abort) THEN BEGIN
      REPEAT
        LastResultOK:=True;
{$I-}
        ChDir(DestPath);
        IF NOT ResultOK THEN IF Floppy THEN BEGIN
          LastResultOK:=False;
          FloppyAbort;
        END;
      UNTIL (LastResultOK OR Abort);
{$I+}
    END;
  UNTIL ((NOT Floppy) OR Abort);
  ShowSize(AllDirSize);
  Write('  Files : ');
  IF NumOfZipFiles > 0 THEN
    Write(NumOfZipFiles,' in ZIP, ');
  IF NumOfArcFiles > 0 THEN
    Write(NumOfArcFiles,' in ARC, ');
  IF NumOfLzhFiles > 0 THEN
    Write(NumOfLzhFiles,' in LZH, ');
  IF NumOfArjFiles > 0 THEN
    Write(NumOfArjFiles,' in ARJ, ');
  Writeln(NumOfFiles,' total');
  IF (Quiet AND Print) THEN BEGIN
    Writeln(LST,'  Files : ');
    IF NumOfZipFiles > 0 THEN
      Write(LST,NumOfZipFiles,' in ZIP, ');
    IF NumOfArcFiles > 0 THEN
      Write(LST,NumOfArcFiles,' in ARC, ');
    IF NumOfLzhFiles > 0 THEN
      Write(LST,NumOfLzhFiles,' in LZH, ');
    IF NumOfArcFiles > 0 THEN
      Write(LST,NumOfArjFiles,' in ARJ, ');
    Writeln(LST,NumOfFiles,' total');
  END;
  IF NOT (FindDir AND FoundFile) THEN
    ChDir(OriginalPath);
  IF Sort THEN SortDirData;
  IF SaveToFile THEN DoFileSave;
{ Release(MemMark);}
END.
